#-*- coding: ISO-8859-1 -*-
import psp2d, pspsnd

class Highscore:
  
  _fileName = "highscore.txt"
  _score = ["1000", "Olga 'Yamochki'", "1000", "Soulstealer", "1000", "UltraViolence"]
  _screen = None
  _font = None
  _image = None
  _buttons = None
  _position = (0, 0)
  _cursor = None
  _chars = [['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O'],
            ['P','Q','R','S','T','U','V','W','X','Y','Z','a','b','c','d'],
            ['e','f','g','h','i','j','k','l','m','n','o','p','q','r','s'],
            ['t','u','v','w','x','y','z','@','?','\\','[',']','{','}','|'],
            ['0','1','2','3','4','5','6','7','8','9',':',';','<','=','>'],
            ['!','"','#','$','%','&',"'",'(',')','*','+',',','-','.',' ']]
  _startButton = None
  _squareButton = None
  _exitButton = None
  
  def __init__(self, screen, font, buttons):
    self._screen = screen
    self._font = font
    self._buttons = buttons
    self._image = psp2d.Image('images/webmage.png')
    self._cursor = psp2d.Image('images/highscorecursor.png')
    self._startButton = psp2d.Image('images/button_start.png')
    self._squareButton = psp2d.Image('images/button_square.png')
    self._exitButton = psp2d.Image('images/button_triangle.png')
    
  def _centerText(self, string, y):
    self._font.drawText(self._screen, (480 - self._font.textWidth(string))/2, y, string)
    
  def show(self):
    """ show the saved highscore
    """
    self._load()
    sound = pspsnd.Music('sound/aloha.xm')
    sound.start()
    self._screen.clear(psp2d.Color(255, 255, 255))
    self._screen.blit(self._image, 0, 0, self._image.width, self._image.height, (480 - self._image.width)/2, 220, False, self._image.width, self._image.height)
    self._centerText('H i g h s c o r e', 5)
    #self._centerText('-----------------------------------', 13)
    self._centerText(self._score[1], 50)
    self._centerText('Advanced Points: ' + self._score[0], 65)  
    self._centerText(self._score[3], 95)
    self._centerText('Intermediate Points: ' + self._score[2], 110)  
    self._centerText(self._score[5], 150)
    self._centerText('Beginner Points: ' + self._score[4], 165)
    self._screen.blit(self._startButton, 0, 0, self._startButton.width, self._startButton.height, 65, 227, True, self._startButton.width, self._startButton.height)
    self._font.drawText(self._screen, 95, 240, "Back")
    self._screen.swap()
    # show until start is pressed
    while True:
      newButtons = self._buttons.MenuController()
      if self._buttons.start in newButtons:
        sound.stop()
        break
      
  def enter(self, level, time):
    """ enter a new the saved highscore
        if it is better as the already stored
    """
    if int(self._score[level*2]) < int(time):
      self._load()
      name = self._score[level*2+1]
      while True:
        newButtons = self._buttons.GameController()
        self._screen.clear(psp2d.Color(255, 255, 255))
        self._screen.blit(self._image, 0, 0, self._image.width, self._image.height, (480 - self._image.width)/2, 220, False, self._image.width, self._image.height)
        self._centerText('N e w   H i g h s c o r e', 5)
        #self._centerText('---------------------------------------------------', 13)
        self._centerText('Enter your name:', 35)
        self._centerText(name, 60)

        self._screen.blit(self._startButton, 0, 0, self._startButton.width, self._startButton.height, 65, 227, True, self._startButton.width, self._startButton.height)
        self._font.drawText(self._screen, 95, 240, "Save")

        self._screen.blit(self._exitButton, 0, 0, self._exitButton.width, self._exitButton.height, 428, 240, True, self._exitButton.width, self._exitButton.height)
        self._font.drawText(self._screen, 444, 240, 'Clear')
        
        self._screen.blit(self._squareButton, 0, 0, self._squareButton.width, self._squareButton.height, 360, 240, True, self._squareButton.width, self._squareButton.height)
        self._font.drawText(self._screen, 376, 240, 'Delete')
        for y in range(6):
          for x in range(15):
            self._font.drawText(self._screen, 92+x*18+(18-(self._font.textWidth(self._chars[y][x]))/2), 110+y*18, (self._chars[y][x]))
        self._screen.blit(self._cursor, 0, 0, self._cursor.width, self._cursor.height, 100+self._position[0]*18, 108+self._position[1]*18, True, self._cursor.width, self._cursor.height)
        self._screen.swap()
        if self._buttons.start in newButtons:
          self._score[level*2] = str(time)
          self._score[level*2+1] = name
          self._save()
          break
        if ((self._buttons.circle in newButtons) or (self._buttons.cross in newButtons)) and len(name) < 25:
          sound = pspsnd.Sound('sound/whip.wav')
          sound.start()          
          name += self._chars[self._position[1]][self._position[0]]
        if (self._buttons.triangle in newButtons):
          name = ""
        if (self._buttons.square in newButtons):
          name = name[0:-1]
        self._position = self._cursorMove(newButtons, self._position, 15, 6)      
      #Show the Highscore
      self.show()
      
  def _cursorMove(self, newButtons, position, maxx, maxy):
    """ moves the cursor in the Array,
        if it gets out of bounds (greater max or lesser zero)
        the cursor switcheses to the other side of the array
    """    
    newx = position[0]
    newy = position[1]
    if self._buttons.down in newButtons:
      newy += 1
      if (newy >= maxy):
        newy = 0
    elif self._buttons.up in newButtons:
      newy -= 1
      if (newy < 0):
        newy = maxy-1
    elif self._buttons.right in newButtons:
      newx += 1
      if (newx >= maxx):
        newx = 0
    elif self._buttons.left in newButtons:        
      newx -= 1
      if (newx < 0):
        newx = maxx-1
    return (newx, newy)
  
  def _save(self):
    """ saves the highscore from a
        variable to a File
    """
    saveFile = file(self._fileName, "w")
    saveFile.write("\n".join(self._score))
    saveFile.close
    
  def _load(self):
    """ loads the highscore from a
        File and stores it in a variable
    """
    try:
      loadFile = file(self._fileName, "r")
      score = loadFile.read()
      self._score = score.split("\n")
      file.close
      return score
    except IOError:
      return ""