#-*- coding: ISO-8859-1 -*-

import psp2d, pspsnd, digits, time, field, highscore

class Game:
  _scr = None
  _fnt = None
  _digits = None
  _state = None
  _seconds = 0
  _buttons = None
  _img = None
  _startTime = None
  _field = None
  _cursor = None
  _position = (0, 0)
  _timeDiff = 0
  _pause = 0
  _exitButton = None
#  _newx = None
#  _newy = None
       
  def __init__(self, screen, font, buttons):
    self._scr = screen
    self._fnt = font
    self._digits = digits.Digits()
    self._img = psp2d.Image('images/background.png')
    self._exitButton = psp2d.Image('images/button_triangle.png')
    self._buttons = buttons
 
  def start(self, maxx, maxy, bombs, timeLimit, level, cheat):
    # initialize values
    # create a playing field with the given dimensions and bombs
    self._field = field.Field(maxx, maxy, bombs)
    # get the start time
    self._startTime = int(time.time())
    # set how often to return the value
    self._buttons.SetGameControllerInterval(8)
    # start game cycles
    while True:
      self._scr.blit(self._img, 0, 0, 480, 272, 0, 0, False, 480, 272)
      self._fnt.drawText(self._scr, 428, 10, 'pyMine')
      self._fnt.drawText(self._scr, 428, 90, 'Bombs:')
      self._fnt.drawText(self._scr, 428, 135, 'Time:')
      # draw the Screen, center it before
      self._field.Draw(self._scr, self._position, cheat)
      # draw the Bombing Information
      self._digits.drawDigits(self._scr, str(bombs - self._field._markedbomb), 4, 428, 105)
      # draw the Time Information
      self._timeDiff = timeLimit + self._pause - (int(time.time()) - self._startTime)
      self._digits.drawDigits(self._scr, str(self._timeDiff), 4, 428, 150, 0)
      self._scr.blit(self._exitButton, 0, 0, self._exitButton.width, self._exitButton.height, 428, 240, True, self._exitButton.width, self._exitButton.height)
      self._fnt.drawText(self._scr, 444, 240, 'Exit')
      newButtons = self._buttons.GameController()

      if (self._timeDiff < 0): 
        #newButtons, score = self._gameOver(newButtons, level)
        self._gameOver(newButtons, level)
        break
      if self._buttons.triangle in newButtons:
        break
      if (self._buttons.cross in newButtons) or (self._buttons.circle in newButtons):
        # try to expand the given position
        if self._field.Expose(self._scr, self._position): 
          #newButtons, score = self._gameOver(newButtons, level)
          self._gameOver(newButtons, level)
          break
      if self._buttons.square in newButtons:
        # cyclic mark/unmark position
        self._field.Mark(self._position)
      if self._buttons.start in newButtons:
        # start the pause timer
        pauseTime = int(time.time())
        score = highscore.Highscore(self._scr, self._fnt, self._buttons)
        score.show()
        # substract the pause timer and remember
        self._pause += int(time.time()) - pauseTime
      self._position = self._cursorMove(newButtons, self._position, maxx, maxy)
      self._scr.swap()

  def _gameOver(self, newButtons, level):
      # wait until keypressed to show field
      if (self._timeDiff < 0):
        self._field.timeOut(self._scr, self._position)
        sound = pspsnd.Sound('sound/cukoo.wav')
      elif self._field.loose:
        sound = pspsnd.Sound('sound/end.wav')
      else:
        sound = pspsnd.Sound('sound/hallelu.wav')
      sound.start()            
      while True:
        newButtons = self._buttons.MenuController()
        if self._buttons.triangle in newButtons:
          break
      # Game Over enter Highscore or show only ?
      score = highscore.Highscore(self._scr, self._fnt, self._buttons)
      if self._field.loose:
        score.show()
      else:
        score.enter(2-level, self._timeDiff)
#      break
#      return newButtons, score

  def _cursorMove(self, newButtons, position, maxx, maxy):
    """ moves the cursor in the Array,
        if it gets out of bounds (greater max or lesser zero)
        the cursor switcheses to the other side of the array
    """ 
    
    newx = position[0]
    newy = position[1]
    if self._buttons.down in newButtons:
      newy += 1
      if (newy >= maxy):
        newy = 0
    elif self._buttons.up in newButtons:
      newy -= 1
      if (newy < 0):
        newy = maxy-1
    elif self._buttons.right in newButtons:
      newx += 1
      if (newx >= maxx):
        newx = 0
    elif self._buttons.left in newButtons:        
      newx -= 1
      if (newx < 0):
        newx = maxx-1
    return (newx, newy)

#    def drawbox(self,screen):
#        #Pseudo 3D Effect Button
#        #upper line                
#        screen.fillRect(self._newx, self._newy, self._newx + 1, self._newy + self._heigth, psp2d.Color(255, 0, 0))
#        #left line
#        screen.fillRect(self._newx, self._newy, self._newx + self._heigth, self._newy + 1, psp2d.Color(255, 0, 0))
#        #lower line
#        screen.fillRect(self._newx + 1, self._newy + self._heigth, self._newx + self._width, 1, psp2d.Color(255, 0, 0))
#        #lower line
#        screen.fillRect(self._newx + 1, self._newy + self._heigth, self._newx + self._width, self._newy + 1, psp2d.Color(255, 0, 0))
