#-*- coding: ISO-8859-1 -*-

import psp2d, status, random

class Field:
  _tileset = None
  _img = None
  _width = 16
  _height = 16

  _playground = None
  _maxx = 0
  _maxy = 0
  _bombs = 0
  _markedbomb = 0
  _field = None
  _tilex = 0
  _tiley = 0
  _random = None
  _remaining = 0
  _exposeList = []
  _refresh = True
  _cachedPlayground = None
  _posx = 0
  _posy = 0
  loose = True
    
  def _InitField(self):
    """ Create an Array and fill it with the initiel values.
        Then fill it randomly with the specified bombs.
    """         
    self._playground = [(status.PlaygroundState.none)] * (self._maxx * self._maxy)
    counter = 0
    # For all the defined Bombs
    while counter < self._bombs:
      #x = int(round(self._random.random() * (self._maxx * self._maxy)-1))
      x = int(round(self._random.randrange(0, (self._maxx * self._maxy)-1)))
      # try to find an empty place
      if not self._isIn(self._playground[x], status.PlaygroundState.bomb):
        # and mark it with an bomb
        self._playground[x] = status.PlaygroundState.bomb
        counter += 1
                
  def _GetSurrounded(self, x, y):
    """ Returns the surrounding Bombs of this Element.
    """
    counter = 0
    if not self._isIn(self._GetSingleElement(x, y), status.PlaygroundState.bomb):
      positions = self._GetSurroundingCoordinates(x, y)
      for position in positions:
        tempElement = self._GetSingleElement(position[0], position[1])
        if self._isIn(tempElement, status.PlaygroundState.bomb):
          counter += 1
    return counter

  def _GetSurroundingCoordinates(self, x, y):
    """ Returns the surrounding Elements of this Element
        all field bounds (below zero and over max) will
        be ignored.
    """ 
    listx = []
    listy = []
    returnList = []
    # get all surroundings (max 8) if they aren't out of field
    if x >0: listx.append(x-1)
    listx.append(x)        
    if x < self._maxx-1: listx.append(x+1)
    if y >0: listy.append(y-1)
    listy.append(y)        
    if y < self._maxy-1: listy.append(y+1)
    # step through all combinations
    for currentx in listx:
      for currenty in listy:
        # except the value given
        if not ((currentx == x) and (currenty == y)):
          # add possible field combination
          returnList.append((currentx, currenty))
    return returnList
  
  def _GetSingleElement(self, x, y):
    """ Returns a single Element, the 2d Coordinates
        will be recalculated to 1d Coordinates.
    """ 
    return (self._playground[((x*self._maxy) + y)]) 

  def _SetSingleElement(self, x, y, value):
    """ Sets a single Element with the given 
        value, the 2d Coordinates will be 
        recalculated to 1d Coordinates.
    """ 
    self._playground[((x*self._maxy) + y)] = (value)

  def Draw(self, screen, cursor, cheat=False):
    """ The complete drawing mechanism of the field class.
        Draws all elements (discovered, and marked)
        of the field and sets the cursor over it 
        at given position.
    """   
    if self._refresh:
      # time to do a full refresh ?!?
      self._refresh = False 
      for x in range(0, self._maxx):
        for y in range(0, self._maxy):
            self._cachedPlayground = self._DrawSingleElement(x, y, self._cachedPlayground)
    # draw the cached playground
    screen.blit(self._cachedPlayground, 0, 0, (self._maxx*self._width), (self._maxy*self._height), self._posx, self._posy, False, (self._maxx*self._width), (self._maxy*self._height))
    # draw the cursor to the given position
    screen.blit(self._img, self._width * 15, 0, self._width, self._height, self._posx + (cursor[0]*self._width ) , self._posy + (cursor[1]*self._height), True, self._width, self._height)
    if cheat:
      if self._isIn(self._GetSingleElement(cursor[0], cursor[1]), status.PlaygroundState.bomb):
          screen.blit(self._img, self._width * 13, 0, self._width, self._height, 428 , 175, False, self._width, self._height)
      else:
          screen.blit(self._img, self._width * 0, 0, self._width, self._height, 428 , 175, False, self._width, self._height)

  def _DrawSingleElement(self, x, y, image):
    """ The drawing mechanism of the given field
        draws all elements (discovered, and marked)
        of the field at given position.
    """
    tmp = self._GetSingleElement(x,y)
    if self._isIn(tmp, status.PlaygroundState.discovered):
      if self._isIn(tmp, status.PlaygroundState.bomb):
        image.blit(self._img, self._width * 13, 0, self._width, self._height, x*self._width , y*self._height, False, self._width, self._height)
      else:
        value = self._GetSurrounded(x, y)
        image.blit(self._img, self._width * value, 0, self._width, self._height, x*self._width , y*self._height, False, self._width, self._height)
    else:
      # marked bomb
      if self._isIn(tmp, status.PlaygroundState.markedbomb):
        image.blit(self._img, self._width * 12, 0, self._width, self._height, x*self._width , y*self._height, False, self._width, self._height)
      # marked unknown
      elif self._isIn(tmp, status.PlaygroundState.markedunknown):
        image.blit(self._img, self._width * 11, 0, self._width, self._height, x*self._width , y*self._height, False, self._width, self._height)
      # undiscovered
      else:
        image.blit(self._img, self._width * 10, 0, self._width, self._height, x*self._width , y*self._height, False, self._width, self._height)
    return image
    
  def Expose(self, screen, cursor):
    """ Exposes the fields of a given position
        all empty fields and the one with
        surrounding Information will be set visible
    """ 
    # set the refres flag
    self._refresh = True
    tmp = self._GetSingleElement(cursor[0], cursor[1])        
    # expose single square at (x,y) and add to list
    if not (self._isIn(tmp, status.PlaygroundState.bomb)):
      # get all surrounding positions
      if self._GetSurrounded(cursor[0], cursor[1]):
        if not self._isIn(tmp, status.PlaygroundState.discovered):
          if (self._isIn(tmp, status.PlaygroundState.markedbomb)):
            self._markedbomb -= 1
          self._remaining -= 1
          self._SetSingleElement(cursor[0], cursor[1], (tmp | status.PlaygroundState.discovered))                
      else:
        # add all surrounding elements
        positions = self._GetSurroundingCoordinates(cursor[0], cursor[1])
        # and at least the element itself
        positions.append(cursor)
        for position in positions:
          tmp = self._GetSingleElement(position[0], position[1])
          if not (self._isIn(tmp, status.PlaygroundState.discovered) or (self._isIn(tmp, status.PlaygroundState.bomb))):                    
            if (self._isIn(tmp, status.PlaygroundState.markedbomb)):
              self._markedbomb -= 1
            self._remaining -= 1
            self._SetSingleElement(position[0], position[1], (tmp | status.PlaygroundState.discovered))
            # call these function recursive
            self.Expose(screen, position)
      if self._remaining == 0:
        # you win the game
        self._win(screen, cursor)
        return True
      else:
        return False
    else:
      # you have lost the game
      self._gameOver(screen, cursor)
      return True

  def _win(self, screen, cursor):
    """ this procedure opens all tiles and set the
        winning condition
    """    
    self._exposeAllFields(screen, cursor)
    self.loose = False
    # Draw the gameover stuff
    img = psp2d.Image('images/you_win.png')
    screen.blit(img, 0, 0, 480, 272, 0, 0, True, 480, 272)
    screen.swap()

  def timeOut(self, screen, cursor):
    """ this procedure opens all tiles and draws the red bomb
        as an overlay the Alpha-Game Over screen is drawn on top
    """
    self._exposeAllFields(screen, cursor)
    # Draw the gameover stuff
    img = psp2d.Image('images/gameover.png')
    screen.blit(img, 0, 0, 480, 272, 0, 0, True, 480, 272)
    screen.swap()
        
  def _gameOver(self, screen, cursor):
    """ this procedure opens all tiles and draws the red bomb
        as an overlay the Alpha-Game Over screen is drawn on top
    """
    self._exposeAllFields(screen, cursor)
    # draw the exploded bomb in red
    screen.blit(self._img, self._width * 14, 0, self._width, self._height, self._posx + (cursor[0]*self._width ) , self._posy + (cursor[1]*self._height), True, self._width, self._height)
    # Draw the gameover stuff
    img = psp2d.Image('images/gameover.png')
    screen.blit(img, 0, 0, 480, 272, 0, 0, True, 480, 272)
    screen.swap()
          
  def _exposeAllFields(self, screen, cursor):
    """ this procedure opens all tiles  
    """
    # Expose all fields
    for x in range(0, self._maxx):
      for y in range(0, self._maxy):       
        self._SetSingleElement(x, y, self._GetSingleElement(x, y) | status.PlaygroundState.discovered)
    self._refresh = True 
    self.Draw(screen, cursor)
        
  def Mark(self, cursor):
    """ Cycles the marking (undiscoverd, markedunknown,
        markedbomb) of the given field.
    """
    # set the refres flag
    self._refresh = True                 
    tmp = self._GetSingleElement(cursor[0], cursor[1])
    # Check if this field is discovered
    if not self._isIn(tmp, status.PlaygroundState.discovered):
      # is it marked unknown -> mark it bomb?
      if self._isIn(tmp, status.PlaygroundState.markedunknown):
        tmp = tmp - status.PlaygroundState.markedunknown + status.PlaygroundState.markedbomb
        self._markedbomb += 1
      # is it marked bomn -> mark it unknown?
      elif self._isIn(tmp, status.PlaygroundState.markedbomb):
        tmp = tmp - status.PlaygroundState.markedbomb
        self._markedbomb -= 1
      else:
        # is it marked nothing -> mark it unknown
        tmp = tmp + status.PlaygroundState.markedunknown
    # set the new value
    self._SetSingleElement(cursor[0], cursor[1], tmp)

  def _isIn(self, byte, bit):
    """ Returns if an given 2 Exponent is in an value
        Example:
          byte = 9   bit = 8 returns True
          byte = 17  bit = 8 returns False
    """         
    if (byte|bit == byte):
      return True
    else:
      return False
    
  def __init__(self, maxx, maxy, bombs, tileset = 'images/field.png'):
    self._tileset = tileset
    # load and cache the tileset
    self._img = psp2d.Image(self._tileset)
    self._maxx = maxx
    self._maxy = maxy
    self._bombs = bombs
    self._random = random.Random()
    self._random.seed()
    self._remaining = (maxx*maxy) - bombs
    self._posx = (428-(maxx*self._width))/2
    self._posy = (272-(maxy*self._height))/2
    self._InitField()
    self._cachedPlayground = psp2d.Image(maxx * self._width, maxy * self._height)
