#-*- coding: ISO-8859-1 -*-

import psp2d#, os
from time import time

class buttons:
  left = 0
  right = 1
  up = 2
  down = 3
  cross = 4
  circle = 5
  square = 6
  triangle = 7
  left_trigger = 8
  right_trigger = 9
  home = 10
  select = 11
  start = 12
  
  _oldPad = None
  _pad = None
  _screen = None
  
  _interval = 5
  _stopwatch = None

  def __init__(self, screen):      
    self._stopwatch = time()
    self._screen = screen

  def _CheckScreenshot(self):
    """ try to create a screenshot,
        if there are screenshots present
        count a number up and try again
    """
    self._pad = psp2d.Controller()
    if self._pad.l and self._pad.r and self._pad.start: 
# TODO: Check where is the OS in PSPPython ???   
#      i = 0
#      while True:
#        i += 1
#        if os.path.isfile("screenshot_" + str(i) + ".png"):
#          break;
#      psp2d.Screen.saveToFile("screenshot_" + str(i) + ".png", psp2d.IMG_PNG)
      i = 0
      while True:
        i += 1
        try:
          f = file("screenshot_" + str(i) + ".png", "r")
          f.close()
        except IOError:
          break
      self._screen.saveToFile("screenshot_" + str(i) + ".png", psp2d.IMG_PNG)

  def MenuController(self):
    """ returns only a return value, if the state
        of the pad had changed at least one value,
        this is good to control on a menu
    """  
    #take eventually a screenshot
    self._CheckScreenshot()
    # do the movement stuff
    self._pad = psp2d.Controller()
    allButtons = []
    if self._oldPad == None or self._oldPad != self._pad:    
      # do the movement stuff
      allButtons = self.ActionGameController()
    return allButtons

  def SetGameControllerInterval(self, interval):
    """
    """
    self._interval = interval
    self._stopwatch = time()
    
  def GameController(self):
    """ returns a cyclic return value,
        i.e. if you hold left, every few miliseconds
        the pad returns the value, this is good to 
        control a cursor on a playfield
    """

    #take eventually a screenshot
    self._CheckScreenshot()
    tmp = time() - self._stopwatch
    self._pad = psp2d.Controller()
    allButtons = []
    if ((tmp * 1000) > (1000/self._interval) or self._oldPad == None or self._oldPad != self._pad):
      #reset the stopwatch for next cycle
      self._stopwatch = time()
      # do the movement stuff
      allButtons = self.ActionGameController()
      tmp = allButtons
    return allButtons

  def ActionGameController(self):
    """ returns the value of the pad, this is good to 
        control a Action Game with very Direct input
    """
    #take eventually a screenshot
    self._CheckScreenshot()
    # do the movement stuff
    allButtons = []    
    self._pad = psp2d.Controller()    
    if self._pad.up:
      allButtons.append(buttons.up)
    if self._pad.down:
      allButtons.append(buttons.down)
    if self._pad.left:
      allButtons.append(buttons.left)
    if self._pad.right:
      allButtons.append(buttons.right)
    if self._pad.circle:
      allButtons.append(buttons.circle)
    if self._pad.square:
      allButtons.append(buttons.square)
    if self._pad.cross:
      allButtons.append(buttons.cross)
    if self._pad.triangle:
      allButtons.append(buttons.triangle)
    if self._pad.select:
      allButtons.append(buttons.select)
    if self._pad.start:
      allButtons.append(buttons.start)
    if self._pad.l:
      allButtons.append(buttons.left_trigger)
    if self._pad.r:
      allButtons.append(buttons.right_trigger)
    self._oldPad = self._pad
    return allButtons
